import sql from "@/app/api/utils/sql";

// Get a single mood entry
export async function GET(request, { params }) {
  try {
    const { id } = params;
    const result = await sql("SELECT * FROM mood_entries WHERE id = $1", [id]);

    if (result.length === 0) {
      return Response.json(
        { success: false, error: "Entry not found" },
        { status: 404 },
      );
    }

    return Response.json({ success: true, entry: result[0] });
  } catch (error) {
    console.error("Error fetching mood entry:", error);
    return Response.json(
      { success: false, error: error.message },
      { status: 500 },
    );
  }
}

// Update a mood entry
export async function PUT(request, { params }) {
  try {
    const { id } = params;
    const body = await request.json();
    const { moodEmoji, moodLabel, note, journalEntry, aiInsight } = body;

    const updates = [];
    const values = [];
    let paramIndex = 1;

    if (moodEmoji !== undefined) {
      updates.push(`mood_emoji = $${paramIndex}`);
      values.push(moodEmoji);
      paramIndex++;
    }
    if (moodLabel !== undefined) {
      updates.push(`mood_label = $${paramIndex}`);
      values.push(moodLabel);
      paramIndex++;
    }
    if (note !== undefined) {
      updates.push(`note = $${paramIndex}`);
      values.push(note);
      paramIndex++;
    }
    if (journalEntry !== undefined) {
      updates.push(`journal_entry = $${paramIndex}`);
      values.push(journalEntry);
      paramIndex++;
    }
    if (aiInsight !== undefined) {
      updates.push(`ai_insight = $${paramIndex}`);
      values.push(aiInsight);
      paramIndex++;
    }

    updates.push(`updated_at = NOW()`);

    if (updates.length === 1) {
      return Response.json(
        { success: false, error: "No fields to update" },
        { status: 400 },
      );
    }

    values.push(id);
    const query = `UPDATE mood_entries SET ${updates.join(", ")} WHERE id = $${paramIndex} RETURNING *`;

    const result = await sql(query, values);

    if (result.length === 0) {
      return Response.json(
        { success: false, error: "Entry not found" },
        { status: 404 },
      );
    }

    return Response.json({ success: true, entry: result[0] });
  } catch (error) {
    console.error("Error updating mood entry:", error);
    return Response.json(
      { success: false, error: error.message },
      { status: 500 },
    );
  }
}

// Delete a mood entry
export async function DELETE(request, { params }) {
  try {
    const { id } = params;
    const result = await sql(
      "DELETE FROM mood_entries WHERE id = $1 RETURNING *",
      [id],
    );

    if (result.length === 0) {
      return Response.json(
        { success: false, error: "Entry not found" },
        { status: 404 },
      );
    }

    return Response.json({ success: true, message: "Entry deleted" });
  } catch (error) {
    console.error("Error deleting mood entry:", error);
    return Response.json(
      { success: false, error: error.message },
      { status: 500 },
    );
  }
}
